package com.agilex.healthcare.directscheduling.dao;

import org.apache.commons.lang.StringUtils;

public class ClinicProvider {
	private String clinicName;
	private String clinicId;
	private String staffName;
	private String facilityCode;
	private String lastName;
	private String firstName;
	private String facilityName;
	
	public String getClinicName() {
		return clinicName;
	}
	public void setClinicName(String clinicName) {
		this.clinicName = clinicName;
	}
	public String getClinicId() {
		return clinicId;
	}
	public void setClinicId(String clinicId) {
		this.clinicId = clinicId;
	}
	public String getStaffName() {
		return staffName;
	}
	public void setStaffName(String staffName) {
		this.staffName = staffName;
	}
	public String getFacilityCode() {
		return facilityCode;
	}
	public void setFacilityCode(String facilityCode) {
		this.facilityCode = facilityCode;
	}
	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getFacilityName() {
		return facilityName;
	}
	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((facilityCode == null) ? 0 : facilityCode.hashCode())
				+ ((staffName == null) ? 0 : staffName.hashCode())
				+ ((clinicId == null) ? 0 : clinicId.hashCode());
				return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ClinicProvider other = (ClinicProvider) obj;
		return StringUtils.equals(facilityCode, other.facilityCode)
		        && (StringUtils.equals(staffName, other.staffName) || (StringUtils.containsIgnoreCase(staffName,other.lastName) && StringUtils.containsIgnoreCase(staffName,other.firstName)))
		        && StringUtils.equals(clinicId, other.clinicId);
	}
}